Imports System
Imports System.Resources
Imports System.Drawing
Imports System.Collections
Imports System.Windows.Forms

Namespace MyResXApp
	Public Class ResXForm 
    Inherits Form
	
		Private WithEvents button2 as Button 
		private WithEvents button1 as Button 

		Public Sub New()
			CenterToScreen()
			InitializeComponent()
		End Sub

		private Sub InitializeComponent()		
			Me.button1 = new System.Windows.Forms.Button()
			Me.button2 = new System.Windows.Forms.Button()
			Me.button1.Location = new System.Drawing.Point(16, 16)
			Me.button1.Size = new System.Drawing.Size(264, 40)
			Me.button1.TabIndex = 0
			Me.button1.Text = "Ajouter des ressources au fichier *.resx"
			Me.button2.Location = new System.Drawing.Point(16, 88)
			Me.button2.Size = new System.Drawing.Size(264, 40)
			Me.button2.TabIndex = 1
			Me.button2.Text = "Lire un fichier *resx"
			Me.AutoScaleBaseSize = new System.Drawing.Size(5, 13)
			Me.ClientSize = new System.Drawing.Size(292, 152)
			Me.Controls.AddRange(new System.Windows.Forms.Control(){ Me.button2,Me.button1})
			Me.Text = "ResX-er"
		End Sub

		protected Sub button2_Click (sender as object, e as System.EventArgs) Handles button2.Click 
			' Construire un lecteur de fichier resx.
			Dim r as ResXResourceReader = _
				new ResXResourceReader("ResXForm.resx")
			
			' Rcuprer l'interface IDictEnum et tout montrer.
			Dim en as IDictionaryEnumerator = r.GetEnumerator()
			while (en.MoveNext()) 
				MessageBox.Show("Valeur:" & en.Value.ToString(), _
					            "Clef: " & en.Key.ToString())
			End While
			r.Close()
		End Sub

		protected Sub button1_Click (sender as object, e as System.EventArgs )Handles button1.Click 
			' Construire un objet pour crire des fichier resx et spcifier le fichier de
			' destination.
			Dim w as ResXResourceWriter = _ 
				new ResXResourceWriter("ResXForm.resx")
			' Un bonhomme souriant.
			Dim i as Image = new Bitmap("happy.bmp")
			w.AddResource("happyDude", i)
			
			' Ajouter une chane.
			w.AddResource("welcomeString", "Bonjour nouveau format de ressource!")

			' Crer et fermer.
			w.Generate()
			w.Close()
		End Sub

		public Shared Sub Main() 
			Application.Run(new ResXForm())
		End Sub
	End Class
End Namespace
